<?php
session_start();
require_once 'connect.php';

if (!isset($_SESSION['current_room_id'])) {
    echo json_encode(['error' => 'No room selected']);
    exit;
}

$roomId = $_SESSION['current_room_id'];

$stmt = $conn->prepare("SELECT room_name, description FROM chat_rooms WHERE id = :id");
$stmt->execute([':id' => $roomId]);
$room = $stmt->fetch(PDO::FETCH_ASSOC);

if ($room) {
    echo json_encode([
        'room_id' => $roomId,
        'room_name' => $room['room_name'],
        'description' => $room['description']
    ]);
} else {
    echo json_encode(['error' => 'Room not found']);
}
?>
