<?php
require_once 'connect.php';
session_start();

if (isset($_POST['email']) && isset($_POST['password'])) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "Invalid email!";
        exit;
    }

    // Fetch user by email
    $sql = "SELECT id, password, user_name FROM users WHERE email = :email";
    $stmt = $conn->prepare($sql);
    $stmt->execute([':email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        // Store user data in session or global as needed
        $_SESSION['user_id']  = $user['id'];
        $_SESSION['user_name'] = $user['user_name'];

        echo "success";
    } else {
        echo "Invalid email or password!";
    }
} else {
    echo "Missing required fields!";
}
?>
