<?php
require 'connect.php';
session_start();

$roomid = $_SESSION['current_room_id'] ?? null;
$creatorId = $_SESSION['user_id'] ?? null;
$uid = $_POST['userid'] ?? null;

if (!$roomid || !$creatorId || !$uid) {
  echo json_encode(["status" => "fail", "message" => "Missing required data."]);
  exit;
}

// Check if current user is the creator of the room
$stmt = $conn->prepare("SELECT created_by FROM chat_rooms WHERE id = ?");
$stmt->execute([$roomid]);
$room = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$room || $room['created_by'] != $creatorId) {
  echo json_encode(["status" => "fail", "message" => "Unauthorized."]);
  exit;
}

// Remove the participant from the room
$stmt = $conn->prepare("DELETE FROM room_members WHERE room_id = ? AND user_id = ?");
$stmt->execute([$roomid, $uid]);

echo json_encode(["status" => "success", "message" => "Participant removed."]);
?>
