<?php
require 'connect.php';
session_start();

$roomid = $_SESSION['current_room_id'] ?? null;
$creatorId = $_SESSION['user_id'] ?? null;
$email = trim($_POST['email'] ?? '');

if (!$roomid || !$creatorId || empty($email)) {
    echo json_encode(["status" => "fail", "message" => "Missing required data."]);
    exit;
}

// Verify if current user is the creator of the room
$stmt = $conn->prepare("SELECT created_by FROM chat_rooms WHERE id = ?");
$stmt->execute([$roomid]);
$room = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$room || $room['created_by'] != $creatorId) {
    echo json_encode(["status" => "fail", "message" => "Unauthorized."]);
    exit;
}

// Check if user exists
$stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo json_encode(["status" => "fail", "message" => "User not found."]);
    exit;
}

// Check if user is already a participant
$stmt = $conn->prepare("SELECT id FROM room_members WHERE room_id = ? AND user_id = ?");
$stmt->execute([$roomid, $user['id']]);
$exists = $stmt->fetch();

if ($exists) {
    echo json_encode(["status" => "fail", "message" => "User already a participant."]);
    exit;
}

// Add user to room_members
$stmt = $conn->prepare("INSERT INTO room_members (room_id, user_id, date_added, member_type, status) VALUES (?, ?, NOW(), 'member', 'active')");
$stmt->execute([$roomid, $user['id']]);

echo json_encode(["status" => "success", "message" => "Participant added successfully."]);
?>
