<?php
$host = "localhost";
$dbname = "chat_app";
$username = "root";
$password = "";

$conn = null;

try {
    // Create PDO connection
    $conn = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username,
        $password,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
    
    // Uncomment for debugging (remove in production)
    // echo "Connected successfully";
    
} catch (PDOException $e) {
    // Log the error to a file (better for production)
    error_log("Database connection failed: " . $e->getMessage(), 3, "db_errors.log");
    
    // Show user-friendly message
    die("Database connection error. Please try again later.");
    
    // For debugging during development only:
    // die("Connection failed: " . $e->getMessage());
}
?>