<?php
require 'connect.php';
session_start();

$roomid = $_SESSION['current_room_id'] ?? null;

if (!$roomid) {
    echo json_encode(['error' => 'No room selected']);
    exit;
}

$stmt = $conn->prepare("
    SELECT 
        u.id AS user_id,
        u.user_name,
        u.email,
        rm.member_type,
        rm.status,
        u.last_seen
    FROM 
        room_members rm
    JOIN 
        users u ON rm.user_id = u.id
    WHERE 
        rm.room_id = ?
");
$stmt->execute([$roomid]);
$participants = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($participants);
?>
