<?php

require_once 'connect.php';

if (isset($_POST['email']) && isset($_POST['username']) && isset($_POST['password'])) {
    $email = trim($_POST['email']);
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    // Basic validation
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "Invalid email address!";
        exit;
    }

    // Check if email already exists
    $checkSql = "SELECT COUNT(*) FROM users WHERE email = :email";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->execute([':email' => $email]);
    $emailExists = $checkStmt->fetchColumn();

    if ($emailExists) {
        echo "Email already registered!";
        exit;
    }

    // Hash password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Insert new user
    $sql = "INSERT INTO users (email, password, user_name, last_seen) 
            VALUES (:email, :password, :username, NOW())";
    $stmt = $conn->prepare($sql);

    $result = $stmt->execute([
        ':email'    => $email,
        ':password' => $hashedPassword,
        ':username' => $username
    ]);

    if ($result) {
        echo "success";
    } else {
        echo "Database error!";
    }

} else {
    echo "Illegal access!";
}
?>
